//######################################
var width = window.innerWidth/2,height = window.innerHeight;
var scene = new THREE.Scene();
var geometry = new THREE.SphereGeometry( 5, 100, 100 ,1.57);
    geometry.scale( - 1, 1, 1 );
var renderer = new THREE.WebGLRenderer();
var camera = new THREE.PerspectiveCamera(75, width / height, 1, 1000);
var controls = new THREE.OrbitControls(camera,renderer.domElement);
//######################################



function show360(vr_jpg_path){
	
    var textureVR = THREE.ImageUtils.loadTexture(vr_jpg_path);
    textureVR.magFilter = THREE.NearestFilter;
	textureVR.minFilter = THREE.LinearFilter;
    var material = new THREE.MeshBasicMaterial( {
       map: textureVR
    } );
  sphere = new THREE.Mesh( geometry, material );
  scene.add( sphere );

  camera.position.set(0,0,0.1);
  camera.lookAt(sphere.position);

  renderer.setSize(width,height);
  renderer.setClearColor({color: 0x000000});
  document.getElementById('stage').appendChild(renderer.domElement);
  renderer.render(scene,camera);

  render();

}

  function render(){
    requestAnimationFrame(render);
    //]
	sphere.rotation.y += 0.004 * Math.PI/180;
    //ʃTCYΉ
    window.addEventListener( 'resize', onWindowResize, false );
    renderer.render(scene,camera);
    controls.update();
  }


  function onWindowResize() {
	//stagẽTCY
	var el = document.getElementById('stage');
	if(el){
		//alert(el.offsetWidth+' and '+el.offsetHeight);
	    camera.aspect = el.offsetWidth / window.innerHeight;
	    camera.updateProjectionMatrix();
	    renderer.setSize( el.offsetWidth, window.innerHeight);
	}else{
		alert('nio');
	}
	
  }


